/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.MutatorByMethodReference;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.engine.DeleteExecutor;
import org.codefilarete.stalactite.engine.EntityCriteria;
import org.codefilarete.stalactite.engine.ExecutableProjection;
import org.codefilarete.stalactite.engine.ExecutableQuery;
import org.codefilarete.stalactite.engine.InsertExecutor;
import org.codefilarete.stalactite.engine.PersistExecutor;
import org.codefilarete.stalactite.engine.SelectExecutor;
import org.codefilarete.stalactite.engine.UpdateExecutor;
import org.codefilarete.stalactite.engine.listener.PersisterListener;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Experimental;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderMap;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.collection.PairIterator;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;

public interface EntityPersister<C, I>
extends PersistExecutor<C>,
InsertExecutor<C>,
UpdateExecutor<C>,
SelectExecutor<C, I>,
DeleteExecutor<C, I>,
PersisterListener<C, I> {
    default public void persist(C entity) {
        this.persist((Iterable<? extends C>)Collections.singleton(entity));
    }

    @Override
    public void persist(Iterable<? extends C> var1);

    default public void insert(C entity) {
        this.insert((C)Collections.singletonList(entity));
    }

    default public void update(C modified, C unmodified, boolean allColumnsStatement) {
        this.update((C)Collections.singletonList(new Duo(modified, unmodified)), allColumnsStatement);
    }

    default public void update(C entity) {
        this.update(entity, true);
    }

    default public void update(C entity, boolean allColumnsStatement) {
        this.update(entity, this.select(this.getId(entity)), allColumnsStatement);
    }

    default public void update(Iterable<C> entities) {
        Set ids = (Set)Iterables.collect(entities, this::getId, KeepOrderSet::new);
        C entitiesFromDb = this.select((I)ids);
        Map idPerEntity = Iterables.map(entities, Function.identity(), this::getId, KeepOrderMap::new);
        Map entityFromDbPerId = Iterables.map(entitiesFromDb, this::getId, Function.identity());
        Map modifiedVsUnmodifiedEntities = Maps.innerJoinOnValuesAndKeys((Map)idPerEntity, (Map)entityFromDbPerId, KeepOrderMap::new);
        this.update((C)((Iterable)() -> new PairIterator(modifiedVsUnmodifiedEntities.keySet(), modifiedVsUnmodifiedEntities.values())), true);
    }

    @Experimental
    default public void update(I id, Consumer<C> entityConsumer) {
        this.update((Iterable<I>)Collections.singleton(id), entityConsumer);
    }

    @Experimental
    default public void update(Iterable<I> ids, Consumer<C> entityConsumer) {
        Object unmodified = this.select((I)ids);
        Object modified = this.select((I)ids);
        modified.forEach(entityConsumer);
        this.update((C)((Iterable)() -> new PairIterator((Iterable)modified, (Iterable)unmodified)), true);
    }

    default public void delete(C entity) {
        this.delete((C)Collections.singletonList(entity));
    }

    default public void deleteById(C entity) {
        this.deleteById((C)Collections.singletonList(entity));
    }

    default public C select(I id) {
        return (C)Iterables.first(this.select((I)Collections.singleton(id)));
    }

    default public Set<C> select(I ... ids) {
        return this.select((I)Arrays.asHashSet((Object[])ids));
    }

    default public <O> ExecutableEntityQuery<C, ?> selectWhere(SerializableFunction<C, O> getter, ConditionalOperator<O, ?> operator) {
        return this.selectWhere(AccessorChain.fromMethodReference(getter), operator);
    }

    default public <O> ExecutableEntityQuery<C, ?> selectWhere(SerializableBiConsumer<C, O> setter, ConditionalOperator<O, ?> operator) {
        return this.selectWhere(Arrays.asList((Object[])new MutatorByMethodReference[]{Accessors.mutatorByMethodReference(setter)}), operator);
    }

    default public <O, A> ExecutableEntityQuery<C, ?> selectWhere(SerializableFunction<C, A> getter1, SerializableFunction<A, O> getter2, ConditionalOperator<O, ?> operator) {
        return this.selectWhere(AccessorChain.fromMethodReferences(getter1, getter2), operator);
    }

    default public <O> ExecutableEntityQuery<C, ?> selectWhere(List<? extends ValueAccessPoint<?>> accessorChain, ConditionalOperator<O, ?> operator) {
        return (ExecutableEntityQuery)this.selectWhere().and(accessorChain, operator);
    }

    default public <O> ExecutableEntityQuery<C, ?> selectWhere(AccessorChain<C, ?> accessorChain, ConditionalOperator<O, ?> operator) {
        return this.selectWhere(accessorChain.getAccessors(), operator);
    }

    default public <O> ExecutableEntityQuery<C, ?> selectWhere(EntityCriteria.CriteriaPath<C, ?> accessorChain, ConditionalOperator<O, ?> operator) {
        return this.selectWhere(accessorChain.getAccessors(), operator);
    }

    default public <O, S extends Collection<O>, NEXT> ExecutableEntityQuery<C, ?> selectWhere(EntityCriteria.SerializableCollectionFunction<C, S, O> accessor1, SerializableFunction<O, NEXT> accessor2, ConditionalOperator<NEXT, ?> operator) {
        return this.selectWhere(new EntityCriteria.CriteriaPath<C, NEXT>(accessor1, accessor2), operator);
    }

    public ExecutableEntityQuery<C, ?> selectWhere();

    default public <O> ExecutableProjectionQuery<C, ?> selectProjectionWhere(Consumer<SelectAdapter<C>> selectAdapter, SerializableFunction<C, O> getter, ConditionalOperator<O, ?> operator) {
        return (ExecutableProjectionQuery)this.selectProjectionWhere(selectAdapter).and(getter, operator);
    }

    default public <O> ExecutableProjectionQuery<C, ?> selectProjectionWhere(Consumer<SelectAdapter<C>> selectAdapter, SerializableBiConsumer<C, O> setter, ConditionalOperator<O, ?> operator) {
        return (ExecutableProjectionQuery)this.selectProjectionWhere(selectAdapter).and(setter, operator);
    }

    default public <O, A> ExecutableProjectionQuery<C, ?> selectProjectionWhere(Consumer<SelectAdapter<C>> selectAdapter, SerializableFunction<C, A> getter1, SerializableFunction<A, O> getter2, ConditionalOperator<O, ?> operator) {
        return this.selectProjectionWhere(selectAdapter, AccessorChain.fromMethodReferences(getter1, getter2).getAccessors(), operator);
    }

    default public <O> ExecutableProjectionQuery<C, ?> selectProjectionWhere(Consumer<SelectAdapter<C>> selectAdapter, List<? extends ValueAccessPoint<?>> accessorChain, ConditionalOperator<O, ?> operator) {
        return (ExecutableProjectionQuery)this.selectProjectionWhere(selectAdapter).and(accessorChain, operator);
    }

    default public <O> ExecutableProjectionQuery<C, ?> selectProjectionWhere(Consumer<SelectAdapter<C>> selectAdapter, EntityCriteria.CriteriaPath<C, ?> accessorChain, ConditionalOperator<O, ?> operator) {
        return this.selectProjectionWhere(selectAdapter, accessorChain.getAccessors(), operator);
    }

    default public <O, S extends Collection<O>, NEXT> ExecutableProjectionQuery<C, ?> selectProjectionWhere(Consumer<SelectAdapter<C>> selectAdapter, EntityCriteria.SerializableCollectionFunction<C, S, O> accessor1, SerializableFunction<O, NEXT> accessor2, ConditionalOperator<O, ?> operator) {
        return this.selectProjectionWhere(selectAdapter, new EntityCriteria.CriteriaPath<C, NEXT>(accessor1, accessor2), operator);
    }

    public ExecutableProjectionQuery<C, ?> selectProjectionWhere(Consumer<SelectAdapter<C>> var1);

    public Set<C> selectAll();

    public boolean isNew(C var1);

    public I getId(C var1);

    public Class<C> getClassToPersist();

    public static interface SelectAdapter<C> {
        public Set<Selectable<?>> getColumns();

        public SelectAdapter<C> distinct();

        public SelectAdapter<C> setDistinct(boolean var1);

        public SelectAdapter<C> add(Selectable<?> var1);

        public SelectAdapter<C> add(Selectable<?> var1, String var2);

        default public SelectAdapter<C> add(EntityCriteria.CriteriaPath<C, ?> property) {
            return this.add(property.getAccessors());
        }

        default public SelectAdapter<C> add(EntityCriteria.CriteriaPath<C, ?> property, String alias) {
            return this.add(property.getAccessors(), alias);
        }

        default public SelectAdapter<C> add(List<ValueAccessPoint<?>> property) {
            return this.add(this.giveColumn(property));
        }

        default public SelectAdapter<C> add(List<ValueAccessPoint<?>> property, String alias) {
            return this.add(this.giveColumn(property), alias);
        }

        default public Selectable<?> giveColumn(ValueAccessPoint<?> property) {
            return this.giveColumn(Arrays.asList((Object[])new ValueAccessPoint[]{property}));
        }

        default public Selectable<?> giveColumn(SerializableFunction<C, ?> property) {
            return this.giveColumn((ValueAccessPoint<?>)Accessors.accessorByMethodReference(property));
        }

        public Selectable<?> giveColumn(List<ValueAccessPoint<?>> var1);
    }

    public static interface ExecutableProjectionQuery<C, SELF extends ExecutableProjectionQuery<C, SELF>>
    extends EntityCriteria<C, SELF>,
    ExecutableProjection,
    EntityCriteria.FluentOrderByClause<C, SELF> {
        public SELF set(String var1, Object var2);

        @Override
        public ExecutableProjectionQuery<C, SELF> beginNested();

        @Override
        public ExecutableProjectionQuery<C, SELF> endNested();
    }

    public static interface ExecutableEntityQuery<C, SELF extends ExecutableEntityQuery<C, SELF>>
    extends EntityCriteria<C, SELF>,
    ExecutableQuery<C>,
    EntityCriteria.FluentOrderByClause<C, SELF> {
        public SELF set(String var1, Object var2);

        @Override
        public ExecutableEntityQuery<C, SELF> beginNested();

        @Override
        public ExecutableEntityQuery<C, SELF> endNested();
    }
}

